<!DOCTYPE html>
<html>
<head>
    <title>Aplikasi Potret Foto Pas Foto</title>
    
    <!-- Google Fonts: Poppins -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>

    <style>
        /* --- CSS Variables & Reset --- */
        :root {
            --primary-color: #4A90E2; /* Biru Segar */
            --primary-dark: #357ABD;
            --secondary-color: #50E3C2; /* Aksen Hijau Mint */
            --background-color: #F4F7F9;
            --card-background: #FFFFFF;
            --text-color: #333333;
            --text-light: #6C757D;
            --border-color: #E0E6ED;
            --border-radius: 12px;
            --shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.05);
            --shadow-md: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 10px 25px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--background-color);
            margin: 0;
            padding: 20px;
            color: var(--text-color);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        /* --- Layout --- */
        .container {
            background-color: var(--card-background);
            padding: 40px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-lg);
            max-width: 500px;
            width: 100%;
            animation: fadeInUp 0.6s ease-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* --- Typography --- */
        h2 {
            color: var(--text-color);
            font-weight: 700;
            font-size: 1.8rem;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }
        h2 svg {
            margin-right: 12px;
            color: var(--primary-color);
        }

        /* --- Form Components --- */
        .form-group {
            margin-bottom: 25px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--text-color);
            font-size: 0.9rem;
        }

        input[type="text"] {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid var(--border-color);
            border-radius: var(--border-radius);
            font-size: 1rem;
            transition: var(--transition);
            background-color: #fdfdfd;
        }

        input[type="text"]:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.2);
        }

        /* --- Buttons --- */
        .button-group {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        button {
            padding: 12px 20px;
            border: none;
            border-radius: var(--border-radius);
            cursor: pointer;
            font-weight: 600;
            font-family: 'Poppins', sans-serif;
            transition: var(--transition);
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Tombol Aksi Utama */
        .btn-primary {
            background-color: var(--primary-color);
            color: white;
            flex-grow: 1; /* Membuat tombol potret memenuhi sisa ruang */
        }
        .btn-primary:hover {
            background-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        /* Tombol Pilihan Rasio (Segmented Control) */
        .ratio-button {
            background-color: var(--background-color);
            color: var(--text-light);
            border: 1px solid var(--border-color);
        }
        .ratio-button.active {
            background-color: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
            box-shadow: var(--shadow-sm);
        }
        .ratio-button:hover:not(.active) {
            background-color: #e9ecef;
        }

        /* --- Area Webcam --- */
        #camera {
            width: 100%;
            max-width: 400px; /* Maksimal lebar */
            height: 300px; /* Rasio aspek 4:3 */
            border: 2px solid var(--border-color);
            border-radius: var(--border-radius);
            overflow: hidden;
            margin: 20px auto; /* Tengah */
            box-shadow: var(--shadow-md);
            background-color: #000;
            position: relative;
        }
        #camera::before { /* Overlay viewfinder */
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            border: 20px solid rgba(0,0,0,0.4);
            pointer-events: none;
        }

        /* --- Modal --- */
        .modal {
            display: none; 
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7); 
            justify-content: center;
            align-items: center;
            padding: 20px;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }

        .modal.show {
            opacity: 1;
            visibility: visible;
        }

        .modal-content {
            background-color: var(--card-background);
            padding: 30px;
            width: 100%;
            max-width: 450px;
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-lg);
            text-align: center;
            transform: scale(0.9);
            transition: transform 0.3s ease;
        }

        .modal.show .modal-content {
            transform: scale(1);
        }

        .modal-content h3 {
            margin-top: 0;
            color: var(--text-color);
            font-weight: 600;
            font-size: 1.4rem;
        }

        #captured-image-preview {
            max-width: 100%;
            height: auto;
            border-radius: var(--border-radius);
            margin: 20px 0;
            box-shadow: var(--shadow-md);
        }
        
        .modal-actions {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 20px;
        }
        
        #save-button, #retake-button {
            padding: 12px 25px;
            font-size: 1rem;
            border-radius: 50px; /* Pill shape */
        }
        
        #save-button {
            background-color: var(--secondary-color);
            color: white;
        }
        #save-button:hover {
            background-color: #3dd4b3;
            transform: translateY(-2px);
        }

        #retake-button {
            background-color: var(--text-light);
            color: white;
        }
        #retake-button:hover {
            background-color: #5a6268;
            transform: translateY(-2px);
        }

        /* --- Responsive Design --- */
        @media (max-width: 600px) {
            body {
                padding: 10px;
            }
            .container {
                padding: 25px;
            }
            h2 {
                font-size: 1.5rem;
            }
            #camera {
                height: 220px;
            }
        }

    </style>
</head>
<body>

    <div class="container">
        <h2>
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z"></path><circle cx="12" cy="13" r="4"></circle></svg>
            Aplikasi Potret Pas Foto
        </h2>
        
        <form id="photo-form" method="POST" action="save_photo.php">
            <div class="form-group">
                <label for="nama">Nama Lengkap:</label>
                <input type="text" id="nama" name="nama" required placeholder="Cth: Nama Lengkap Anda">
            </div>

            <div class="form-group">
                <label>Pilih Rasio:</label>
                <div class="button-group">
                    <button type="button" class="ratio-button active" data-ratio="3x4">Pas Foto 3x4</button>
                    <!-- Tambahkan tombol rasio lain di sini jika perlu -->
                </div>
                <input type="hidden" name="ratio" id="selected-ratio" value="3x4">
            </div>

            <div id="camera"></div>
            
            <button type="button" class="btn-primary" onClick="take_snapshot()">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-right: 8px;"><circle cx="12" cy="12" r="10"></circle><circle cx="12" cy="12" r="3"></circle></svg>
                Potret Foto
            </button>

            <input type="hidden" name="image" class="image-tag" value="">
        </form>
    </div>

    <div id="previewModal" class="modal">
        <div class="modal-content">
            <h3>Konfirmasi Foto Anda</h3>
            <div id="modal-results"></div>
            <div class="modal-actions">
                <button type="submit" form="photo-form" id="save-button">✅ Simpan Foto</button>
                <button type="button" id="retake-button" onclick="closeModal()">🔄 Potret Ulang</button>
            </div>
        </div>
    </div>
    
    <script language="JavaScript">
        // 1. Konfigurasi Webcam
        Webcam.set({
            width: 400,
            height: 300,
            image_format: 'jpeg',
            jpeg_quality: 95
        });
        Webcam.attach('#camera');

        // 2. Fungsi Potret
        function take_snapshot() {
            if ($('#nama').val().trim() === '') {
                alert('Silakan masukkan Nama Lengkap terlebih dahulu.');
                $('#nama').focus(); // Fokus ke input nama
                return;
            }
            Webcam.snap(function(data_uri) {
                document.getElementById('modal-results').innerHTML = 
                    '<img id="captured-image-preview" src="'+data_uri+'"/>';
                $(".image-tag").val(data_uri);
                openModal();
            });
        }
        
        // 3. Fungsi Modal dengan animasi
        function openModal() {
            const modal = document.getElementById('previewModal');
            modal.style.display = 'flex';
            // Trigger reflow untuk memulai transisi
            modal.offsetHeight; 
            modal.classList.add('show');
        }

        function closeModal() {
            const modal = document.getElementById('previewModal');
            modal.classList.remove('show');
            setTimeout(() => {
                modal.style.display = 'none';
            }, 300); // Sesuaikan dengan durasi transisi CSS
        }
        
        // 4. Logika untuk Pilihan Rasio
        $('.ratio-button').click(function() {
            $('.ratio-button').removeClass('active');
            $(this).addClass('active');
            $('#selected-ratio').val($(this).data('ratio'));
        });
    </script>

</body>
</html>

