<?php
// functions.php

/**
 * Mengambil data sekolah berdasarkan ID.
 */
function getSchool($conn, $id) {
    $stmt = $conn->prepare("SELECT * FROM schools WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

/**
 * Mengambil data kelas berdasarkan ID, beserta nama sekolahnya.
 */
function getClass($conn, $id) {
    $stmt = $conn->prepare("SELECT c.*, s.name as school_name FROM classes c LEFT JOIN schools s ON c.school_id = s.id WHERE c.id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

/**
 * Mengambil data siswa berdasarkan ID, beserta nama kelas dan KKM-nya.
 */
function getStudentDetails($conn, $id) {
    $stmt = $conn->prepare("
        SELECT 
            s.*, 
            c.name AS class_name, 
            c.kktp,
            sch.name AS school_name
        FROM students s
        JOIN classes c ON s.class_id = c.id
        JOIN schools sch ON c.school_id = sch.id
        WHERE s.id = ?
    ");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    return $stmt->get_result()->fetch_assoc();
}

// Hapus tag penutup untuk keamanan