<?php include 'header.php'; 
// Variabel yang diterima: $class, $assessment, $students, $chapters, $existing_scores
?>
<a href="index.php?action=view_class_dashboard&class_id=<?php echo $class['id']; ?>" class="text-blue-600 hover:text-blue-800 mb-6 block">&larr; Kembali ke Dashboard Kelas</a>

<h2 class="text-2xl font-bold text-gray-800 mb-3">Input Nilai <?php echo htmlspecialchars($assessment['name']); ?> (<?php echo htmlspecialchars($assessment['assessment_type']); ?>)</h2>
<p class="text-gray-600 mb-6">Kelas: **<?php echo htmlspecialchars($class['name']); ?>** | KKTP: **<?php echo htmlspecialchars($class['kktp']); ?>**</p>

<form method="POST" action="index.php">
    <input type="hidden" name="submit_grades" value="1">
    <input type="hidden" name="class_id" value="<?php echo $class['id']; ?>">
    <input type="hidden" name="assessment_id" value="<?php echo $assessment['id']; ?>">

    <div class="overflow-x-auto">
        <table class="whitespace-nowrap">
            <thead>
                <tr class="bg-gray-100">
                    <th rowspan="2">Nama Siswa</th>
                    <th colspan="3" class="text-center border-b">Jawaban Benar Global (Soal)</th>
                    <?php foreach ($chapters as $chapter): ?>
                        <th colspan="<?php echo count($chapter['tps']) + 2; ?>" class="text-center border-b" title="<?php echo htmlspecialchars($chapter['description']); ?>"><?php echo htmlspecialchars($chapter['name']); ?></th>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <th class="border-t">PG (<?php echo $assessment['pg_total']; ?>)</th>
                    <th class="border-t">Isian (<?php echo $assessment['isian_total']; ?>)</th>
                    <th class="border-t">Essay (<?php echo $assessment['essay_total']; ?>)</th>
                    
                    <?php foreach ($chapters as $chapter): 
                        $chapter_id = $chapter['id'];
                    ?>
                        <?php foreach ($chapter['tps'] as $k => $tp): ?>
                            <th class="border-t" title="<?php echo htmlspecialchars($tp['description']); ?>">TP<?php echo $k + 1; ?> (100)</th>
                        <?php endforeach; ?>
                        <th class="border-t">Nilai SLM (100)</th>
                        <th class="border-t">Status</th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $student): 
                    $student_id = $student['id'];
                    $scores = $existing_scores[$student_id] ?? [];
                    $global = $scores['global'] ?? [];
                ?>
                <tr class="hover:bg-gray-50">
                    <td>
                        <?php echo htmlspecialchars($student['name']); ?>
                        <input type="hidden" name="student_id[]" value="<?php echo $student_id; ?>">
                    </td>
                    
                    <td><input type="number" name="pg_correct[<?php echo $student_id; ?>]" min="0" max="<?php echo $assessment['pg_total']; ?>" value="<?php echo htmlspecialchars($global['pg_correct'] ?? ''); ?>" class="w-16 p-1 border rounded text-right"></td>
                    <td><input type="number" name="isian_correct[<?php echo $student_id; ?>]" min="0" max="<?php echo $assessment['isian_total']; ?>" value="<?php echo htmlspecialchars($global['isian_correct'] ?? ''); ?>" class="w-16 p-1 border rounded text-right"></td>
                    <td><input type="number" name="essay_correct[<?php echo $student_id; ?>]" min="0" max="<?php echo $assessment['essay_total']; ?>" value="<?php echo htmlspecialchars($global['essay_correct'] ?? ''); ?>" class="w-16 p-1 border rounded text-right"></td>
                    
                    <?php foreach ($chapters as $chapter): 
                        $chapter_id = $chapter['id'];
                        $chap_scores = $scores['chapters'][$chapter_id] ?? [];
                        $tps_scores = $scores['tps'] ?? [];
                    ?>
                        <?php foreach ($chapter['tps'] as $tp): 
                            $tp_id = $tp['id'];
                        ?>
                            <td><input type="number" name="tp_score[<?php echo $student_id; ?>][<?php echo $tp_id; ?>]" min="0" max="100" step="0.01" value="<?php echo htmlspecialchars($tps_scores[$tp_id] ?? ''); ?>" class="w-16 p-1 border rounded text-right"></td>
                        <?php endforeach; ?>

                        <td><input type="number" name="slm_score[<?php echo $student_id; ?>][<?php echo $chapter_id; ?>]" min="0" max="100" step="0.01" value="<?php echo htmlspecialchars($chap_scores['slm_score'] ?? ''); ?>" class="w-16 p-1 border rounded text-right"></td>
                        
                        <td>
                            <select name="status[<?php echo $student_id; ?>][<?php echo $chapter_id; ?>]" required class="p-1 border rounded text-sm w-28">
                                <option value="BELUM KOMPETEN" <?php echo ($chap_scores['status'] ?? '') == 'BELUM KOMPETEN' ? 'selected' : ''; ?>>BELUM KOMPETEN</option>
                                <option value="PERLU BIMBINGAN" <?php echo ($chap_scores['status'] ?? '') == 'PERLU BIMBINGAN' ? 'selected' : ''; ?>>PERLU BIMBINGAN</option>
                                <option value="KOMPETEN" <?php echo ($chap_scores['status'] ?? '') == 'KOMPETEN' ? 'selected' : ''; ?>>KOMPETEN</option>
                            </select>
                        </td>
                    <?php endforeach; ?>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-6 flex justify-end">
        <button type="submit" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-6 rounded-lg transition">
            Simpan Nilai <?php echo htmlspecialchars($assessment['assessment_type']); ?>
        </button>
    </div>
</form>

<?php include 'footer.php'; ?>