<?php include 'header.php'; ?>

<div class="mb-6">

<div class="mb-6">
    <?php if (isset($_SESSION['is_viewer']) && $_SESSION['is_viewer']): ?>
        <div class="flex gap-4 items-center">
            <a href="index.php?action=viewer_exit_to_admin" class="text-blue-600 hover:text-blue-800 font-semibold">Masuk ke Mode Admin</a>
        </div>
        <h2 class="text-2xl font-bold text-gray-800 mt-2">Laporan Nilai: <?php echo htmlspecialchars($class['name']); ?></h2>
        <p class="text-gray-600">Mode Viewer (Read-Only) | KKM: <?php echo $class['kktp']; ?></p>
    <?php else: ?>
        <a href="index.php?action=view_class_dashboard&class_id=<?php echo $class_id; ?>" class="text-blue-600 hover:text-blue-800 font-semibold">&larr; Kembali ke Dashboard Kelas</a>
        <h2 class="text-2xl font-bold text-gray-800 mt-2">Rekapitulasi Nilai Kelas: <?php echo htmlspecialchars($class['name']); ?></h2>
        <p class="text-gray-600">KKM: <?php echo $class['kktp']; ?></p>
    <?php endif; ?>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    
    <div class="lg:col-span-2 p-6 bg-gray-50 rounded-xl shadow-inner border border-gray-200">
        <h3 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2">Daftar Siswa dan Nilai Akhir <span class="text-base font-medium text-blue-600 ml-2">(<?php echo htmlspecialchars($assessment['type'] ?? 'General'); ?>)</span></h3>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Siswa</th>
                        <th class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Rata-rata Nilai</th>
                        <th class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Detail</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php if (empty($students)): ?>
                        <tr><td colspan="4" class="text-center py-4 text-gray-500">Belum ada siswa di kelas ini.</td></tr>
                    <?php else: ?>
                        <?php foreach($students as $student): ?>
                            <?php $scores = $all_students_scores[$student['id']] ?? []; ?>
                            <?php 
                                $status_color = 'bg-gray-200 text-gray-800';
                                if ($scores['status'] === 'KOMPETEN') {
                                    $status_color = 'bg-green-100 text-green-800 border border-green-300';
                                } elseif ($scores['status'] === 'BELUM KOMPETEN') {
                                    $status_color = 'bg-red-100 text-red-800 border border-red-300';
                                }
                            ?>
                            <tr class="<?php echo ($selected_student_id == $student['id']) ? 'bg-indigo-50 font-bold' : ''; ?>">
                                <td class="px-3 py-3 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo htmlspecialchars($student['name']); ?>
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-center text-sm font-medium">
                                    <?php echo $scores['final_average'] > 0 ? $scores['final_average'] : '-'; ?>
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-center">
                                    <span class="inline-flex px-3 py-1 text-xs leading-5 font-semibold rounded-full <?php echo $status_color; ?>">
                                        <?php echo $scores['status']; ?>
                                    </span>
                                </td>
                                <td class="px-3 py-3 whitespace-nowrap text-right text-sm font-medium">
                                    <?php if ($scores['status'] !== 'BELUM DINILAI'): ?>
                                        <a href="index.php?action=view_class_scores&class_id=<?php echo $class_id; ?>&student_id=<?php echo $student['id']; ?>" class="text-indigo-600 hover:text-indigo-900 ml-4">Lihat Detail</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <div class="lg:col-span-1">
        <?php if ($selected_student_details): ?>
            <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-100 sticky top-4">
                <h3 class="text-xl font-bold text-indigo-800 mb-4 border-b pb-2">Detail Nilai Siswa: <?php echo htmlspecialchars($selected_student_details['student_name']); ?></h3>
                
                <p class="text-lg font-semibold mb-2">Rata-rata Akhir: 
                    <span class="ml-2 px-3 py-1 rounded-lg text-white font-bold <?php echo ($selected_student_details['final_average'] >= $class['kktp']) ? 'bg-green-600' : 'bg-red-600'; ?>">
                        <?php echo $selected_student_details['final_average']; ?>
                    </span>
                </p>

                <div class="bg-gray-50 p-3 rounded-lg text-sm mb-4">
                    <h4 class="font-semibold text-gray-700 mb-1">Jawaban Global (Benar)</h4>
                    <?php if ($selected_student_details['global_answers']): ?>
                        <p>PG: <?php echo $selected_student_details['global_answers']['pg_correct']; ?>, Isian: <?php echo $selected_student_details['global_answers']['isian_correct']; ?>, Esai: <?php echo $selected_student_details['global_answers']['essay_correct']; ?></p>
                    <?php else: ?>
                        <p class="text-red-500">Data Jawaban Global tidak ditemukan.</p>
                    <?php endif; ?>
                </div>

                <div class="bg-white p-4 rounded-lg shadow-sm mt-4">
                    <h4 class="font-semibold text-gray-700 mb-2 border-b pb-1">Rangkuman Nilai Bab</h4>
                    <?php if ($selected_student_details['lm_descriptions']): ?>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <?php 
                            // Asumsi chapter_finals dan lm_descriptions terurut berdasarkan bab
                            foreach ($selected_student_details['lm_descriptions'] as $i => $lm): 
                                $bab_score = $selected_student_details['chapter_finals'][$i] ?? 'N/A';
                                $status = ($bab_score >= $class['kktp']) ? 'KOMPETEN' : 'BELUM KOMPETEN';
                                $score_class = ($bab_score >= $class['kktp']) ? 'text-green-600' : 'text-red-600';
                            ?>
                                <li>
                                    <span class="font-semibold text-blue-700"><?php echo htmlspecialchars($lm['name']); ?> (<?php echo $lm['description']; ?>):</span>
                                    <span class="ml-2 font-bold <?php echo $score_class; ?>"><?php echo $bab_score; ?></span>
                                    <span class="ml-2 text-xs font-medium <?php echo $score_class; ?>">(<?php echo $status; ?>)</span>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-sm text-gray-500 italic">Belum ada deskripsi LM.</p>
                    <?php endif; ?>
                </div>

                <div class="bg-white p-4 rounded-lg shadow mt-6">
                    <h4 class="font-semibold text-gray-700 mb-2 border-b pb-1">Deskripsi Tujuan Pembelajaran (TP)</h4>
                    <?php if ($selected_student_details['tp_descriptions']): ?>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <?php foreach ($selected_student_details['tp_descriptions'] as $tp): ?>
                                <li>
                                    <span class="font-semibold text-indigo-700"><?php echo htmlspecialchars($tp['name']); ?>:</span>
                                    <p class="text-gray-500 mt-1"><?php echo htmlspecialchars($tp['description']); ?></p>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-sm text-gray-500 italic">Belum ada deskripsi TP.</p>
                    <?php endif; ?>
                </div>

            </div>
        <?php else: ?>
            <div class="bg-yellow-50 p-6 rounded-xl shadow-inner border border-yellow-200">
                <p class="text-center text-gray-700 font-semibold">
                    Klik "Lihat Detail" pada salah satu siswa di sebelah kiri untuk melihat rincian nilai, jawaban, dan deskripsi TP/Bab.
                </p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'footer.php'; ?>